﻿IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[hips].[HealthProviderIndividualGetAll] ') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [hips].[HealthProviderIndividualGetAll] 
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Create date: 2 April 2012
-- Description:   Gets all records from the HealthProviderIndividual Table
-- =============================================
CREATE PROCEDURE [hips].[HealthProviderIndividualGetAll] 
AS
BEGIN

	SELECT  DISTINCT
			hpi.HealthProviderIndividualId,
			hpi.IamProviderIdentifier,
			hpih.HpiI,
			hpih.HpiiLastValidated,	
			hpih.HpiiStatusId,			
			hpi.TitleId,
			hpi.DeactivatedDate,
			t.Description AS Title,		
			hpi.FamilyName,
			hpi.GivenNames,		
			hpi.SuffixId,
			s.Description AS Suffix,
			hpi.LocalProviderCode,
			hpi.DateCreated,
			hpi.UserCreated,
			hpi.DateModified,
			hpi.UserModified
	FROM hips.HealthProviderIndividual hpi
	LEFT JOIN hips.HospitalHealthProviderIndividual AS hhpi ON hhpi.HealthProviderIndividualId = hpi.HealthProviderIndividualId
	LEFT JOIN hips.HealthProviderIndividualHpii AS hpih ON hpi.HealthProviderIndividualId = hpih.HealthProviderIndividualId 
	INNER JOIN hips.Title AS t ON t.TitleId = hpi.TitleId
	INNER JOIN hips.Suffix AS s ON s.SuffixId = hpi.SuffixId

END
GO
